/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.shop.Workplace;
import java.util.Date;

public abstract class WorkplaceActivity
extends Activity {
    private final Workplace workplace;

    protected WorkplaceActivity(long start, long end, Workplace workplace) {
        this.workplace = workplace;
        this.doSetStartEnd(start, end);
    }

    protected WorkplaceActivity(long time) {
        super.setStartEnd(time, time);
        this.workplace = null;
    }

    public Workplace getWorkplace() {
        return this.workplace;
    }

    @Override
    public void setStart(long start) {
        this.doSetStartEnd(start, this.end);
    }

    @Override
    public void setEnd(long end) {
        this.doSetStartEnd(this.start, end);
    }

    @Override
    public void setStartEnd(long start, long end) {
        this.doSetStartEnd(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetStartEnd(long start, long end) {
        block7: {
            if (this.start != start || this.end != end) {
                WorkplaceSchedule wps;
                WorkplaceSchedule workplaceSchedule = wps = this.isStoredInWorkplaceSchedule() ? this.getPlan().getWorkplaceSchedule(this.getWorkplace()) : null;
                if (wps != null) {
                    wps.preUpdateActivity(this);
                }
                try {
                    if (start < end) {
                        super.setStartEnd(start, end);
                        break block7;
                    }
                    throw new IllegalStateException("WorkplaceActivity must hold: start < end.");
                }
                finally {
                    if (wps != null) {
                        wps.postUpdateActivity(this);
                    }
                }
            }
        }
    }

    protected boolean isStoredInWorkplaceSchedule() {
        return this.getPlan() != null;
    }

    @Override
    protected void preSetPlan() {
        Plan origPlan = this.getPlan();
        if (origPlan != null) {
            WorkplaceSchedule ws = origPlan.getWorkplaceSchedule(this.getWorkplace());
            ws.removeActivity(this);
        }
    }

    @Override
    protected void postSetPlan() {
        Plan plan = this.getPlan();
        if (plan != null) {
            WorkplaceSchedule ws = plan.getWorkplaceSchedule(this.getWorkplace());
            ws.addActivity(this);
        }
    }

    abstract void accept(WorkplaceActivityVisitor var1);

    public String toString() {
        Comparable<Long> oend;
        Comparable<Long> ostart;
        if (Activity.convertDatesInToString) {
            ostart = new Date(this.getStart());
            oend = new Date(this.getEnd());
        } else {
            ostart = this.getStart();
            oend = this.getEnd();
        }
        if (this.workplace != null) {
            return String.format("%s(start=%s, end=%s, at=%s, @%x)", this.getClass().getSimpleName(), ostart, oend, this.getWorkplace().toString(), System.identityHashCode(this));
        }
        return String.format("%s(start=%s, end=%s, at=?)", this.getClass().getSimpleName(), ostart, oend);
    }
}

